<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<script src="https://code.jquery.com/jquery-3.6.1.min.js" integrity="sha256-o88AwQnZB+VDvE9tvIXrMQaPlFFSUTR+nldQm1LuPXQ=" crossorigin="anonymous"></script>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/semantic-ui/2.5.0/semantic.min.css" integrity="sha512-KXol4x3sVoO+8ZsWPFI/r5KBVB/ssCGB5tsv2nVOKwLg33wTFP3fmnXa47FdSVIshVTgsYk/1734xSk9aFIa4A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
	<script src="https://cdnjs.cloudflare.com/ajax/libs/semantic-ui/2.5.0/semantic.min.js" integrity="sha512-Xo0Jh8MsOn72LGV8kU5LsclG7SUzJsWGhXbWcYs2MAmChkQzwiW/yTQwdJ8w6UA9C6EVG18GHb/TrYpYCjyAQw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
	<title></title>
	<style type="text/css">
		* {
  box-sizing: border-box;
}

body {
  margin: 0;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  height: 100vh;
  font-family: "Montserrat", sans-serif;
}

.wrapper {
  display: flex;
  flex-flow: row wrap;
  justify-content: center;
}

.card {
  width: 350px;
  height: 100px;
  margin: 1em;
  perspective: 1500px;
  cursor: pointer;
}
.card .content {
  position: relative;
  width: 100%;
  height: 100%;
  transform-style: preserve-3d;
  transition: transform 0.8s cubic-bezier(0.75, 0, 0.85, 1);
}

.more {
  display: none;
}
.more:checked ~ .content {
  transform: rotateY(180deg);
}

.front,
.back {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  backface-visibility: hidden;
  transform-style: preserve-3d;
  border-radius: 6px;
}
.front .inner,
.back .inner {
  height: 100%;
  display: grid;
  padding: 1.5em;
  transform: translateZ(80px) scale(0.94);
}

.front {
  background-color: #fff;
  background-size: cover;
  background-position: center center;
}
.front:after {
  content: "";
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  display: block;
  border-radius: 6px;
  backface-visibility: hidden;
  background: linear-gradient(40deg, rgba(0, 0, 0, 0.7), rgba(0, 159, 255, 0.7));
}
.front .inner {
  grid-template-rows: 5fr 1fr 1fr 2fr 1fr;
  justify-items: center;
}
.front h1 {
  grid-row: 2;
  margin-bottom: 1em;
  text-transform: uppercase;
  letter-spacing: 3px;
  color: #fff;
  font-weight: 600;
  text-shadow: 0 0 6px rgba(0, 0, 0, 0.1);
}

::-webkit-scrollbar {
  width: 5px;
}

::-webkit-scrollbar-track {
  background: #f1f1f1;
}

::-webkit-scrollbar-thumb {
  background: #859ddf;
}

::-webkit-scrollbar-thumb:hover {
  background: #355cc9;
}
	</style>
</head>
<body>
<div class="ui container fluid" style="position: absolute;top: 0;height: 100px;background:url(images/top-full-bg.jpg) repeat-x #0085D1;">
	
</div>
<div class="wrapper">
  <div class="card" onclick="window.open('agent/','welcome', 'width=1250,height=1000,menubar=0,status=0,toolbar=0,fullscreen=1,location=0');">
    <input type="checkbox" id="card1" class="more" aria-hidden="true">
    <div class="content">
      <div class="front">
        <div class="inner">
          <h1>Agent Login</h1>
        </div>
      </div>
    </div>
  </div>
  <div class="card" onclick="admin_open();">
    <input type="checkbox" id="card2" class="more">
    <div class="content">
      <div class="front">
        <div class="inner">
          <h1>Admin Login</h1>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="ui segment center aligned middle aligned " style="position: absolute;bottom: 0;width: 100%;height: 80px;margin: 0px !important;background: linear-gradient(40deg, rgba(0, 0, 0, 0.7), rgba(0, 159, 255, 0.7))">
	<p style="margin-top: 15px;font-size: 17px;">All rights reserved copyright  &copy; <a href="http://www.eurus.net" target="_blank" style="color: white;text-decoration: underline;">Eurus Network Services Pvt. Ltd.</a></p>
</div>
</body>
<script type="text/javascript">
	function admin_open()
	{
		window.location.href = "./admin/index.php";
	}
</script>
</html>