<?php
# phone_stats.php
# 
# Copyright (C) 2022  Matt Florell <vicidial@gmail.com>    LICENSE: AGPLv2
#
# 
# changes:
# 60620-1333 - Added variable filtering to eliminate SQL injection attack threat
#            - Added required user/pass to gain access to this page
# 60927-1548 - Changed to vicidial_users for authentication
# 90508-0644 - Changed to PHP long tags
# 120223-2135 - Removed logging of good login passwords if webroot writable is enabled
# 130610-1110 - Finalized changing of all ereg instances to preg
# 130617-2156 - Added filtering of input to prevent SQL injection attacks and new user auth
# 130901-0900 - Changed to mysqli PHP functions
# 140328-0005 - Converted division calculations to use MathZDC function
# 141114-0034 - Finalized adding QXZ translation to all admin files
# 141128-0903 - Code cleanup for QXZ functions
# 141230-0911 - Added code for on-the-fly language translations display
# 170409-1534 - Added IP List validation code
# 210812-1614 - Added slave DB and user group allowed reports permissions code, and report log logging
# 220303-1538 - Added allow_web_debug system setting
#

$startMS = microtime();

require("dbconnect_mysqli.php");
require("functions.php");

$PHP_AUTH_USER=$_SERVER['PHP_AUTH_USER'];
$PHP_AUTH_PW=$_SERVER['PHP_AUTH_PW'];
$PHP_SELF=$_SERVER['PHP_SELF'];
$PHP_SELF = preg_replace('/\.php.*/i','.php',$PHP_SELF);
if (isset($_GET["begin_date"]))				{$begin_date=$_GET["begin_date"];}
	elseif (isset($_POST["begin_date"]))	{$begin_date=$_POST["begin_date"];}
if (isset($_GET["end_date"]))				{$end_date=$_GET["end_date"];}
	elseif (isset($_POST["end_date"]))		{$end_date=$_POST["end_date"];}
if (isset($_GET["extension"]))				{$extension=$_GET["extension"];}
	elseif (isset($_POST["extension"]))		{$extension=$_POST["extension"];}
if (isset($_GET["server_ip"]))				{$server_ip=$_GET["server_ip"];}
	elseif (isset($_POST["server_ip"]))		{$server_ip=$_POST["server_ip"];}
if (isset($_GET["user"]))				{$user=$_GET["user"];}
	elseif (isset($_POST["user"]))		{$user=$_POST["user"];}
if (isset($_GET["full_name"]))				{$full_name=$_GET["full_name"];}
	elseif (isset($_POST["full_name"]))		{$full_name=$_POST["full_name"];}
if (isset($_GET["submit"]))				{$submit=$_GET["submit"];}
	elseif (isset($_POST["submit"]))	{$submit=$_POST["submit"];}
if (isset($_GET["SUBMIT"]))				{$SUBMIT=$_GET["SUBMIT"];}
	elseif (isset($_POST["SUBMIT"]))	{$SUBMIT=$_POST["SUBMIT"];}
if (isset($_GET["DB"]))						{$DB=$_GET["DB"];}
	elseif (isset($_POST["DB"]))			{$DB=$_POST["DB"];}

$DB = preg_replace('/[^0-9]/','',$DB);

$STARTtime = date("U");
$TODAY = date("Y-m-d");
$admin_page = './admin.php';
$date = date("r");
$ip = getenv("REMOTE_ADDR");
$browser = getenv("HTTP_USER_AGENT");
if (!isset($begin_date)) {$begin_date = $TODAY;}
if (!isset($end_date)) {$end_date = $TODAY;}

$report_name = 'Phone Stats';
$db_source = 'M';

#############################################
##### START SYSTEM_SETTINGS LOOKUP #####
$stmt = "SELECT use_non_latin,webroot_writable,outbound_autodial_active,user_territories_active,enable_languages,language_method,slave_db_server,reports_use_slave_db,allow_web_debug FROM system_settings;";
$rslt=mysql_to_mysqli($stmt, $link);
#if ($DB) {echo "$stmt\n";}
$qm_conf_ct = mysqli_num_rows($rslt);
if ($qm_conf_ct > 0)
	{
	$row=mysqli_fetch_row($rslt);
	$non_latin =					$row[0];
	$webroot_writable =				$row[1];
	$SSoutbound_autodial_active =	$row[2];
	$user_territories_active =		$row[3];
	$SSenable_languages =			$row[4];
	$SSlanguage_method =			$row[5];
	$slave_db_server =				$row[6];
	$reports_use_slave_db =			$row[7];
	$SSallow_web_debug =			$row[8];
	}
if ($SSallow_web_debug < 1) {$DB=0;}
##### END SETTINGS LOOKUP #####
###########################################

$extension = preg_replace("/\<|\>|\'|\"|\\\\|;/", '', $extension);
$server_ip = preg_replace("/\<|\>|\'|\"|\\\\|;/", '', $server_ip);
$begin_date = preg_replace("/\<|\>|\'|\"|\\\\|;/","",$begin_date);
$end_date = preg_replace("/\<|\>|\'|\"|\\\\|;/","",$end_date);
$full_name = preg_replace("/\<|\>|\'|\"|\\\\|;/","",$full_name);
$submit = preg_replace("/\<|\>|\'|\"|\\\\|;/","",$submit);
$SUBMIT = preg_replace("/\<|\>|\'|\"|\\\\|;/","",$SUBMIT);

if ($non_latin < 1)
	{
	$PHP_AUTH_USER = preg_replace('/[^-_0-9a-zA-Z]/', '', $PHP_AUTH_USER);
	$PHP_AUTH_PW = preg_replace('/[^-_0-9a-zA-Z]/', '', $PHP_AUTH_PW);
	$user = preg_replace('/[^-_0-9a-zA-Z]/', '', $user);
	}
else
	{
	$PHP_AUTH_USER = preg_replace('/[^-_0-9\p{L}]/u', '', $PHP_AUTH_USER);
	$PHP_AUTH_PW = preg_replace('/[^-_0-9\p{L}]/u', '', $PHP_AUTH_PW);
	$user = preg_replace('/[^-_0-9\p{L}]/u', '', $user);
	}

$stmt="SELECT selected_language from vicidial_users where user='$PHP_AUTH_USER';";
if ($DB) {echo "|$stmt|\n";}
$rslt=mysql_to_mysqli($stmt, $link);
$sl_ct = mysqli_num_rows($rslt);
if ($sl_ct > 0)
	{
	$row=mysqli_fetch_row($rslt);
	$VUselected_language =		$row[0];
	}

$auth=0;
$reports_auth=0;
$admin_auth=0;
$auth_message = user_authorization($PHP_AUTH_USER,$PHP_AUTH_PW,'REPORTS',1,0);
if ($auth_message == 'GOOD')
	{$auth=1;}

if ($auth > 0)
	{
	$stmt="SELECT count(*) from vicidial_users where user='$PHP_AUTH_USER' and user_level > 7 and view_reports='1';";
	if ($DB) {echo "|$stmt|\n";}
	$rslt=mysql_to_mysqli($stmt, $link);
	$row=mysqli_fetch_row($rslt);
	$admin_auth=$row[0];

	$stmt="SELECT count(*) from vicidial_users where user='$PHP_AUTH_USER' and user_level > 6 and view_reports='1';";
	if ($DB) {echo "|$stmt|\n";}
	$rslt=mysql_to_mysqli($stmt, $link);
	$row=mysqli_fetch_row($rslt);
	$reports_auth=$row[0];

	if ($reports_auth < 1)
		{
		$VDdisplayMESSAGE = _QXZ("You are not allowed to view reports");
		Header ("Content-type: text/html; charset=utf-8");
		echo "$VDdisplayMESSAGE: |$PHP_AUTH_USER|$auth_message|\n";
		exit;
		}
	if ( ($reports_auth > 0) and ($admin_auth < 1) )
		{
		$ADD=999999;
		$reports_only_user=1;
		}
	}
else
	{
	$VDdisplayMESSAGE = _QXZ("Login incorrect, please try again");
	if ($auth_message == 'LOCK')
		{
		$VDdisplayMESSAGE = _QXZ("Too many login attempts, try again in 15 minutes");
		Header ("Content-type: text/html; charset=utf-8");
		echo "$VDdisplayMESSAGE: |$PHP_AUTH_USER|$auth_message|\n";
		exit;
		}
	if ($auth_message == 'IPBLOCK')
		{
		$VDdisplayMESSAGE = _QXZ("Your IP Address is not allowed") . ": $ip";
		Header ("Content-type: text/html; charset=utf-8");
		echo "$VDdisplayMESSAGE: |$PHP_AUTH_USER|$auth_message|\n";
		exit;
		}
	Header("WWW-Authenticate: Basic realm=\"CONTACT-CENTER-ADMIN\"");
	Header("HTTP/1.0 401 Unauthorized");
	echo "$VDdisplayMESSAGE: |$PHP_AUTH_USER|$PHP_AUTH_PW|$auth_message|\n";
	exit;
	}

##### BEGIN log visit to the vicidial_report_log table #####
$LOGip = getenv("REMOTE_ADDR");
$LOGbrowser = getenv("HTTP_USER_AGENT");
$LOGscript_name = getenv("SCRIPT_NAME");
$LOGserver_name = getenv("SERVER_NAME");
$LOGserver_port = getenv("SERVER_PORT");
$LOGrequest_uri = getenv("REQUEST_URI");
$LOGhttp_referer = getenv("HTTP_REFERER");
$LOGbrowser=preg_replace("/\'|\"|\\\\/","",$LOGbrowser);
$LOGrequest_uri=preg_replace("/\'|\"|\\\\/","",$LOGrequest_uri);
$LOGhttp_referer=preg_replace("/\'|\"|\\\\/","",$LOGhttp_referer);
if (preg_match("/443/i",$LOGserver_port)) {$HTTPprotocol = 'https://';}
  else {$HTTPprotocol = 'http://';}
if (($LOGserver_port == '80') or ($LOGserver_port == '443') ) {$LOGserver_port='';}
else {$LOGserver_port = ":$LOGserver_port";}
$LOGfull_url = "$HTTPprotocol$LOGserver_name$LOGserver_port$LOGrequest_uri";

$LOGhostname = php_uname('n');
if (strlen($LOGhostname)<1) {$LOGhostname='X';}
if (strlen($LOGserver_name)<1) {$LOGserver_name='X';}

$stmt="SELECT webserver_id FROM vicidial_webservers where webserver='$LOGserver_name' and hostname='$LOGhostname' LIMIT 1;";
$rslt=mysql_to_mysqli($stmt, $link);
if ($DB) {echo "$stmt\n";}
$webserver_id_ct = mysqli_num_rows($rslt);
if ($webserver_id_ct > 0)
	{
	$row=mysqli_fetch_row($rslt);
	$webserver_id = $row[0];
	}
else
	{
	##### insert webserver entry
	$stmt="INSERT INTO vicidial_webservers (webserver,hostname) values('$LOGserver_name','$LOGhostname');";
	if ($DB) {echo "$stmt\n";}
	$rslt=mysql_to_mysqli($stmt, $link);
	$affected_rows = mysqli_affected_rows($link);
	$webserver_id = mysqli_insert_id($link);
	}

$stmt="INSERT INTO vicidial_report_log set event_date=NOW(), user='$PHP_AUTH_USER', ip_address='$LOGip', report_name='$report_name', browser='$LOGbrowser', referer='$LOGhttp_referer', notes='$LOGserver_name:$LOGserver_port $LOGscript_name |$end_date, $shift, $file_download, $report_display_type|', url='$LOGfull_url', webserver='$webserver_id';";
if ($DB) {echo "|$stmt|\n";}
$rslt=mysql_to_mysqli($stmt, $link);
$report_log_id = mysqli_insert_id($link);
##### END log visit to the vicidial_report_log table #####

if ( (strlen($slave_db_server)>5) and (preg_match("/$report_name/",$reports_use_slave_db)) )
	{
	mysqli_close($link);
	$use_slave_server=1;
	$db_source = 'S';
	require("dbconnect_mysqli.php");
#	echo "<!-- Using slave server $slave_db_server $db_source -->\n";
	}

$stmt="SELECT user_group,full_name from vicidial_users where user='$PHP_AUTH_USER';";
if ($DB) {echo "|$stmt|\n";}
$rslt=mysql_to_mysqli($stmt, $link);
$row=mysqli_fetch_row($rslt);
$LOGuser_group =	$row[0];
$LOGfullname =		$row[1];

$stmt="SELECT allowed_campaigns,allowed_reports,admin_viewable_groups,admin_viewable_call_times from vicidial_user_groups where user_group='$LOGuser_group';";
if ($DB) {echo "|$stmt|\n";}
$rslt=mysql_to_mysqli($stmt, $link);
$row=mysqli_fetch_row($rslt);
$LOGallowed_campaigns =			$row[0];
$LOGallowed_reports =			$row[1];
$LOGadmin_viewable_groups =		$row[2];
$LOGadmin_viewable_call_times =	$row[3];

if ( (!preg_match("/$report_name/",$LOGallowed_reports)) and (!preg_match("/ALL REPORTS/",$LOGallowed_reports)) )
	{
    Header("WWW-Authenticate: Basic realm=\"CONTACT-CENTER-ADMIN\"");
    Header("HTTP/1.0 401 Unauthorized");
    echo "You are not allowed to view this report: |$PHP_AUTH_USER|$report_name|\n";
    exit;
	}


##### get server listing for dynamic pulldown
$stmt="SELECT fullname from phones where server_ip='$server_ip' and extension='$extension';";
$rsltx=mysql_to_mysqli($stmt, $link);
$rowx=mysqli_fetch_row($rsltx);
$fullname = $row[0];

require("screen_colors.php");
?>
<html>
<head>
<script language="JavaScript" src="help.js"></script>
<script src="inc\libs\jquery\jquery.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<link rel="stylesheet" href="inc\libs\bootstrap\bootstrap.css">
<link rel="stylesheet" href="inc/js/multiselect/dist/css/bootstrap-multiselect.css">
<link rel="stylesheet" href="inc/js/multiselect/dist/css/bootstrap-multiselect.min.css">
<link rel="stylesheet" href="inc/libs/sidebar5/css/next-sidebar.css" />
<link rel="stylesheet" href="inc/libs/sidebar5/css/perfect-scrollbar.css" />
<link rel="stylesheet" href="inc/css/style.css">
<title><?php echo _QXZ("ADMIN: Phone Stats"); ?></title>
</head>
<BODY BGCOLOR=white marginheight=0 marginwidth=0 leftmargin=0 topmargin=0>
<?php
	require("admin_header.php");
	echo "<div class=\"container-fluid admin_form_blocks\">";
	echo "<div class=\"container-fluid admin_form_heading text-center\"><span>"._QXZ("Phone Stats")." &nbsp; &nbsp; &nbsp; $user - $full_name</span></div>";
	echo "<table class=\"table table-sm table-bordered mt-3 admin_form_table\"><thead><tr><td><a href=\"$admin_page?ADD=10000000000\">". _QXZ("LIST ALL PHONES")."</a></td><td><a href=\"$admin_page?ADD=11111111111\">"._QXZ("ADD A NEW PHONE")."</a></td><td><a href=\"$admin_page?ADD=551\">"._QXZ("SEARCH FOR A PHONE")."</a></td><td><a href=\"$admin_page?ADD=111111111111\">"._QXZ("ADD A SERVER")."</a></td><td><a href=\"$admin_page?ADD=100000000000\">"._QXZ("LIST ALL SERVERS")."</a></td><td><a href=\"$admin_page?ADD=1000000000000\">"._QXZ("SHOW ALL CONFERENCES")."</a></td><td><a href=\"$admin_page?ADD=1111111111111\">"._QXZ("ADD A NEW CONFERENCE")."</a></td></tr></thead><</table>";


	echo "<div class=\"container-fluid mt-3\">";
	echo "<form action=$PHP_SELF method=POST>\n";
	echo "<div class=\"form-row\">";
	echo "<input type=hidden name=extension value=\"$extension\">\n";
	echo "<input type=hidden name=server_ip value=\"$server_ip\">\n";
	echo "<div class=\"form-group col-sm-4\"><label>From</label><input class=\"form-control\" type=text name=begin_date value=\"$begin_date\" size=10 maxsize=10></div>";
	echo "<div class=\"form-group col-sm-4\"><label>To</label><input class=\"form-control\"t type=text name=end_date value=\"$end_date\" size=10 maxsize=10></div>";
	echo "<div class=\"form-group col-sm-4\"><label>&nbsp;</label><br><input class=\"btn btn-secondary\" type=submit name=submit value='"._QXZ("submit")."'></div></div>";

$stmt="SELECT count(*),channel_group, sum(length_in_sec) from call_log where extension='" . mysqli_real_escape_string($link, $extension) . "' and server_ip='" . mysqli_real_escape_string($link, $server_ip) . "' and start_time >= '" . mysqli_real_escape_string($link, $begin_date) . " 0:00:01'  and start_time <= '" . mysqli_real_escape_string($link, $end_date) . " 23:59:59' group by channel_group order by channel_group";
$rslt=mysql_to_mysqli($stmt, $link);
$statuses_to_print = mysqli_num_rows($rslt);
#	echo "|$stmt|\n";
	echo "</div></div>";
echo "<div class=\"container-fluid admin_form_blocks mt-3\">";
echo "<div class=\"text-center admin_form_subHeading\"><span>"._QXZ("CALL TIME AND CHANNELS")."</span></div>";

echo "<TABLE class=\"table table-sm table-bordered mt-3 admin_form_table\">\n";
echo "<thead><tr><th>"._QXZ("CHANNEL GROUP")."</th><th align=right>"._QXZ("COUNT")."</th><th>"._QXZ("HOURS:MINUTES")."</th></tr></thead><tbody>";

$total_calls=0;
$o=0;
while ($statuses_to_print > $o) 
	{
	$row=mysqli_fetch_row($rslt);
	if (preg_match('/1$|3$|5$|7$|9$/i', $o))
		{$bgcolor='bgcolor="#B9CBFD"';} 
	else
		{$bgcolor='bgcolor="#9BB9FB"';}

	$call_seconds = $row[2];
	$call_hours = MathZDC($call_seconds, 3600);
	$call_hours = round($call_hours, 2);
	$call_hours_int = intval("$call_hours");
	$call_minutes = ($call_hours - $call_hours_int);
	$call_minutes = ($call_minutes * 60);
	$call_minutes_int = round($call_minutes, 0);
	if ($call_minutes_int < 10) {$call_minutes_int = "0$call_minutes_int";}

	echo "<tr ><td>$row[1]</td>";
	echo "<td align=right> $row[0]</td>\n";
	echo "<td align=right> $call_hours_int:$call_minutes_int</td></tr>\n";
	$total_calls = ($total_calls + $row[0]);

	$call_seconds=0;
	$o++;
	}

	$stmt="SELECT sum(length_in_sec) from call_log where extension='" . mysqli_real_escape_string($link, $extension) . "' and server_ip='" . mysqli_real_escape_string($link, $server_ip) . "' and start_time >= '" . mysqli_real_escape_string($link, $begin_date) . " 0:00:01'  and start_time <= '" . mysqli_real_escape_string($link, $end_date) . " 23:59:59'";
	$rslt=mysql_to_mysqli($stmt, $link);
	$counts_to_print = mysqli_num_rows($rslt);
		$row=mysqli_fetch_row($rslt);
	$call_seconds = $row[0];
	$call_hours = MathZDC($call_seconds, 3600);
	$call_hours = round($call_hours, 2);
	$call_hours_int = intval("$call_hours");
	$call_minutes = ($call_hours - $call_hours_int);
	$call_minutes = ($call_minutes * 60);
	$call_minutes_int = round($call_minutes, 0);
	if ($call_minutes_int < 10) {$call_minutes_int = "0$call_minutes_int";}
#	echo "|$stmt|\n";

echo "</tbody><thead><tr><th>"._QXZ("TOTAL CALLS")." </td><td align=right> $total_calls</td><td align=right> $call_hours_int:$call_minutes_int</td></tr></thead>";
echo "</TABLE>";

echo "<div class=\"text-center admin_form_subHeading\"><span>"._QXZ("LAST 1000 CALLS FOR DATE RANGE")."</span></div>";
echo "<TABLE class=\"table table-sm table-bordered mt-3 admin_form_table\">\n";
echo "<thead><tr><th>"._QXZ("NUMBER")." </th><th>"._QXZ("CHANNEL GROUP")." </th><th align=right>"._QXZ("DATE")."</th><th align=right> "._QXZ("LENGTH(MIN.)")."</th></tr></thead><tbody>";

$stmt="SELECT number_dialed,channel_group,start_time,length_in_min from call_log where extension='" . mysqli_real_escape_string($link, $extension) . "' and server_ip='" . mysqli_real_escape_string($link, $server_ip) . "' and start_time >= '" . mysqli_real_escape_string($link, $begin_date) . " 0:00:01'  and start_time <= '" . mysqli_real_escape_string($link, $end_date) . " 23:59:59' LIMIT 1000";
$rslt=mysql_to_mysqli($stmt, $link);
$events_to_print = mysqli_num_rows($rslt);
#	echo "|$stmt|\n";

$total_calls=0;
$o=0;
$event_start_seconds='';
$event_stop_seconds='';
while ($events_to_print > $o) 
	{
	$row=mysqli_fetch_row($rslt);
	if (preg_match('/1$|3$|5$|7$|9$/i', $o))
		{$bgcolor='bgcolor="#B9CBFD"';} 
	else
		{$bgcolor='bgcolor="#9BB9FB"';}
	echo "<tr><td>$row[0]</td>";
	echo "<td align=right> $row[1]</td>\n";
	echo "<td align=right> $row[2]</td>\n";
	echo "<td align=right> $row[3]</td></tr>\n";

	$call_seconds=0;
	$o++;
	}

echo "</tbody></TABLE>";

$ENDtime = date("U");

$RUNtime = ($ENDtime - $STARTtime);

echo "</div>";
// echo "<font size=0>\n\n\n<br><br><br>\n"._QXZ("script runtime").": $RUNtime "._QXZ("seconds")."</font>";

?>


</TD></TR><TABLE>
</body>
<?php
	echo "<script src=\"inc/libs/cookie/src/jquery.cookie.js\"></script>";
	echo "<script src=\"inc/js/custom_javascript.js\"></script>";
	echo "<script src=\"inc/libs/sidebar5/js/perfect-scrollbar.min.js\"></script>";
	echo "<script src=\"inc/libs/lordicons/lordiIcon.js\"></script>";
	echo "<script src=\"inc\libs\bootstrap\bootstrap.js\"></script>";
	echo "<script src=\"inc/js/multiselect/dist/js/bootstrap-multiselect.js\"></script>";
	echo "<script src=\"inc/libs/sidebar5/js/next-sidebar.js\"></script><script>	$(function(){ $('.multi_select').multiselect();});</script>";
?>
</html>

<?php


if ($db_source == 'S')
	{
	mysqli_close($link);
	$use_slave_server=0;
	$db_source = 'M';
	require("dbconnect_mysqli.php");
	}

$endMS = microtime();
$startMSary = explode(" ",$startMS);
$endMSary = explode(" ",$endMS);
$runS = ($endMSary[0] - $startMSary[0]);
$runM = ($endMSary[1] - $startMSary[1]);
$TOTALrun = ($runS + $runM);

$stmt="UPDATE vicidial_report_log set run_time='$TOTALrun' where report_log_id='$report_log_id';";
if ($DB) {echo "|$stmt|\n";}
$rslt=mysql_to_mysqli($stmt, $link);

exit; 

?>

